/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater;

import com.sun.tools.tzupdater.Logger;
import com.sun.tools.tzupdater.Messages;
import com.sun.tools.tzupdater.TimezoneUpdater;
import com.sun.tools.tzupdater.TzRuntimeException;
import com.sun.tools.tzupdater.TzupdaterException;
import com.sun.tools.tzupdater.Verifier;
import com.sun.tools.tzupdater.utils.TarInputStream;
import com.sun.tools.tzupdater.utils.TestDataGenerator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import tools.javazic.Main;
import tools.tzdb.TzdbZoneRulesCompiler;

class ExternalModule {
    static String tmpPath;
    static final String SHA512_SITE = "https://javadl-esd-secure.oracle.com/update/tzupdater/";

    ExternalModule() {
    }

    protected static String downloadFile(String string, String string2, boolean bl) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        FileOutputStream fileOutputStream = null;
        String string3 = "";
        try {
            int n;
            URL uRL = new URL(string);
            string3 = uRL.getProtocol();
            if (!(string3.equals("http") || string3.equals("https") || string3.equals("file"))) {
                throw new TzRuntimeException(Messages.printf("unsupported.protocol", string3));
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(20000);
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            fileOutputStream = new FileOutputStream(string2);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (MalformedURLException malformedURLException) {
            throw new TzRuntimeException(Messages.printf("bad.url", string), malformedURLException);
        }
        catch (IOException iOException) {
            if (bl) {
                Logger.println(Messages.printf("tool.tzdata.version", "N/A\nIOException while accessing resource: " + string));
                Logger.println(Messages.printf("network.issue"));
                throw new TzupdaterException();
            }
            if (iOException instanceof SocketTimeoutException || iOException instanceof NoRouteToHostException) {
                Logger.println(Messages.printf("network.issue"));
                throw new TzRuntimeException(Messages.printf("network.issue.short", string3), iOException);
            }
            throw new TzRuntimeException(Messages.printf("download.error", string), iOException);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        if (!bl) {
            Logger.println("Downloaded file to " + string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void extractFiles(String string) throws IOException {
        InputStream inputStream = null;
        String string2 = string.substring(0, string.lastIndexOf(File.separator));
        File file = new File(string);
        if (!file.canRead()) {
            throw new IOException("Cannot read " + string);
        }
        try {
            TarInputStream tarInputStream = new TarInputStream(new GZIPInputStream((InputStream)new FileInputStream(file), 8192));
            inputStream = new BufferedInputStream(tarInputStream);
            TarInputStream.TarEntry tarEntry = null;
            OutputStream outputStream = null;
            byte[] byArray = new byte[8192];
            while ((tarEntry = tarInputStream.getNextEntry()) != null) {
                int n = 0;
                try {
                    outputStream = new FileOutputStream(new File(string2, tarEntry.getName()));
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    if (outputStream == null) continue;
                    outputStream.close();
                }
            }
            ExternalModule.copyLegacyFiles(string2);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyLegacyFiles(String string) throws IOException {
        String[] stringArray = new String[]{"gmt", "jdk11_backward", "jdk11_backward_jsr310", "solar87", "solar88", "solar89"};
        byte[] byArray = new byte[8192];
        InputStream inputStream = null;
        OutputStream outputStream = null;
        for (String string2 : stringArray) {
            try {
                inputStream = ExternalModule.class.getResourceAsStream("/data/legacy/" + string2);
                outputStream = new FileOutputStream(new File(string, string2));
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
    }

    protected static void createVersionFile(String string, String string2) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(new File(string, "VERSION"));
            outputStream.write(string2.getBytes("UTF-8"));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Issue while extracting " + iOException);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected static void compileToJSRBinary(String string, String string2) {
        String[] stringArray = TimezoneUpdater.getVerboseFlag() ? new String[]{"-srcdir", string, "-dstfile", string2, "-verbose"} : new String[]{"-srcdir", string, "-dstfile", string2};
        TzdbZoneRulesCompiler.main(stringArray);
    }

    protected static void compileToZiBinary(String string, String string2) throws IOException {
        String string3 = string2 + File.separator + "zi";
        File file = new File(string3);
        if (!file.mkdir()) {
            throw new TzupdaterException("Problem creating temp directory " + file);
        }
        Main main = new Main(string, string2, string3);
        int n = main.compile();
        if (n != 0) {
            throw new TzupdaterException("Problem during compileToZiBinary");
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(new File(string2, "dynamic_tzdata.zip"))));
            ExternalModule.prepareZipFile(string3, zipOutputStream, "");
        }
        catch (IOException iOException) {
            throw new TzupdaterException("Problem while creating rules in zip file " + iOException);
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void prepareZipFile(String string, ZipOutputStream zipOutputStream, String string2) throws IOException {
        File file = new File(string);
        String[] stringArray = file.list();
        byte[] byArray = new byte[8192];
        int n = 0;
        ZipEntry zipEntry = null;
        for (String string3 : stringArray) {
            Object object;
            File file2 = new File(file, string3);
            if (file2.isDirectory()) {
                object = file2.getPath();
                String string4 = string2.equals("") ? string2 : string2 + "/";
                zipEntry = new ZipEntry(string4 + string3 + "/");
                zipOutputStream.putNextEntry(zipEntry);
                ExternalModule.prepareZipFile((String)object, zipOutputStream, string2 + file2.getName() + "/");
                continue;
            }
            object = new FileInputStream(file2);
            try {
                zipEntry = new ZipEntry(string2 + file2.getName());
                zipOutputStream.putNextEntry(zipEntry);
                n = ((FileInputStream)object).read(byArray);
                while (n != -1) {
                    zipOutputStream.write(byArray, 0, n);
                    n = ((FileInputStream)object).read(byArray);
                }
            }
            finally {
                zipOutputStream.closeEntry();
                ((FileInputStream)object).close();
            }
        }
    }

    protected static void compileTestFiles(String string) throws IOException {
        TestDataGenerator testDataGenerator = new TestDataGenerator(string);
        if (!TimezoneUpdater.isJSR310()) {
            Verifier.clearTzCaches();
        }
        String[] stringArray = TimeZone.getAvailableIDs();
        TestDataGenerator.dumpIDs(stringArray);
    }
}

